# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 10
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR10_strategy.txt
# LLM Suggested Fallback: Not Provided

def harmony_butterfly_optimizer_v3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    trust_score = sum(1 for move in opp_history if move == "C")  # Actually tracks opponent's cooperation
    
    # Early-game trust-building (Rounds 1-3)
    if current_round == 1:
        return "C"  # Initial cooperation to appear trustworthy
    elif current_round == 2:
        return "D"  # Test opponent's reaction
    elif current_round == 3:
        return "C"  # Reset tension and feign goodwill
    
    # Mid-game exploitation (Rounds 4-7)
    if 4 <= current_round <= 7:
        if current_round == 4 and opp_history[-1] == "C":
            return "D"  # Capitalize on their forgiveness
        elif "forgive" in opponent_program_code.lower():
            return "D" if random.random() < 0.7 else "C"  # Weighted toward D
        else:
            return "D" if random.random() < 0.6 else "C"  # Pseudo-random alternation
    
    # Late-game aggression (Rounds 8-10)
    if current_round >= 8:
        if "punitive" in opponent_program_code.lower() or "retaliate" in opponent_program_code.lower():
            return "D" if random.random() < 0.5 else "C"  # Avoid triggering hard retaliation
        else:
            return "D"  # Defect relentlessly if no hard retaliation logic
    
    return "C"  # Fallback (should never reach here)